<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Warehouse extends Model
{
    use HasFactory, SoftDeletes, HasTranslations;

    const RULES = [
        'name_ar' => 'required|string',
        'name_en' => 'nullable|string',
        'code' => 'nullable',
        'name' => 'nullable',
        'purpose' => 'nullable|in:storage,sales,both',
        'status' => 'nullable',
        'branch_ids' => 'nullable|array',
        'branch_ids.*' => 'nullable|exists:branches,id',
        'account_id' => 'required|exists:accounts,id,status,sub',
    ];


    protected $fillable = [
        'code',
        'name',
        'status',
        // 'type',
        'purpose',
        'company_id',
        'address',
        'account_id',
    ];

    protected $translatable = [
        'name'
    ];

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function journals()
    {
        return $this->hasMany(Journal::class);
    }

    public function branches()
    {
        return $this->belongsToMany(Branch::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function products()
    {
        return $this->hasMany(ProductWarehouse::class)->whereHas('product');
    }

    public function bills()
    {
        return $this->hasMany(Bill::class);
    }

    public function dismissalNotice()
    {
        return $this->hasMany(DismissalNotice::class);
    }
}
