<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WarehouseUnit extends Model
{
    use HasFactory;

    protected $fillable = [
        'unit_id',
        'selling_price',
        'purchasing_price',
        'product_warehouse_id',
    ];

    public function productWarehouse()
    {
        return $this->belongsTo(ProductWarehouse::class);
    }

    public function unit()
    {
        return $this->belongsTo(CompanyUnit::class, 'unit_id');
    }
}
