<?php

namespace App\Providers;

use App\Models\Bill;
use App\Events\NewCompany;
use App\Listeners\CompanyRole;
use App\Observers\BillObserver;
use App\Events\GroupSettingEvent;
use App\Listeners\GroupSubSetting;
use Illuminate\Support\Facades\Event;
use App\Listeners\CompanyMainAccounts;
use App\Listeners\CompanyMainSettings;
use App\Listeners\SendEmailOtp;
use App\Events\JournalRepeationExpiration;
use App\Listeners\UpdateExpirationStatus;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        NewCompany::class => [
            CompanyMainAccounts::class,
            CompanyMainSettings::class,
            CompanyRole::class,
            SendEmailOtp::class,
        ],
        GroupSettingEvent::class => [
            GroupSubSetting::class,
        ],
         JournalRepeationExpiration::class => [
            UpdateExpirationStatus::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        Bill::observe(BillObserver::class);
    }
}
