<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class AccountTypeSameParent implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(public null|string $type)
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if(!is_null($this->type))
        {
            return $this->type ==  $value;
        }
        return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The account type must match with the parent account.';
    }
}
