<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckPaymentType implements ValidationRule
{
    private string $field;
    private mixed $paymentMethod;

    /**
     * Create a new rule instance.
     *
     * @param string $field
     * @param mixed $paymentMethod
     */
    public function __construct(string $field, mixed $paymentMethod)
    {
        $this->field = $field;
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * Run the validation rule.
     *
     * @param string $attribute
     * @param mixed $value
     * @param \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if ($this->paymentMethod == 4) {
            if ($this->field === 'phone' && empty($value)) {
                $fail(__('Phone is required when payment method is 4.'));
            }

            if ($this->field === 'id' && !is_null($value)) {
                $fail(__('ID must be nullable when payment method is 4.'));
            }
        }
    }
}
