<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;


class NoScriptOrStyleTags implements Rule
{
    public function passes($attribute, $value)
    {
        // Check for script and style tags
        return !preg_match('/^(<style>|<script>)/i', $value);

    }

    public function message()
    {
        return 'The :attribute field contains invalid content (script or style tags).';
    }
}
