<?php

namespace App\Rules;

use App\Http\Helper\CompanyHelper;
use App\Models\Supplier;
use Closure;
use Illuminate\Contracts\Validation\Rule;

class UniqueSpecialSupplier implements Rule
{
    protected $companyId;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->companyId = CompanyHelper::getCompany(request())->id;
    }
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!$value) {
            return true;
        }

        $existingSpecialSupplier = Supplier::where('company_id', $this->companyId)
            ->where('special', true)
            ->first();

        $routeSupplier = request()->route()->supplier;

        if (!$routeSupplier && !$existingSpecialSupplier) {
            return true;
        }

        return  $existingSpecialSupplier->is($routeSupplier);
    }
    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return __('messages.cannot_add_more_than_special_supplier');
    }
}
