<?php

namespace App\Rules;

use App\Http\Helper\CompanyHelper;
use Illuminate\Contracts\Validation\Rule;

class ValidPaymentMethodRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
     public function passes($attribute, $value)
    {
        return CompanyHelper::getCompany(request())->paymentMethods()->where('payment_method_id', $value)->exists();
    }

    public function message()
    {
        return __('messages.payment_method_not_available');
    }
}
