<?php

namespace App\Trait;

use App\Models\Journal;
use App\Http\Enums\Bill\BillEnum;
use App\Http\Helper\AccountHelper;
use App\Jobs\ProductTrackQuantity;
use Illuminate\Support\Facades\DB;
use App\Http\Services\Account\AccountService;
use App\Http\Services\Account\JournalService;


trait BillJournalEntryTrait
{
    private function getDescription(): string
    {
        return ($this->billService->bill->type === BillEnum::sales->value) ? __('constants.sales_description') : __('constants.purchase_description');
    }

    private function createSalesJournalEntries(): void
    {

        DB::transaction(function () {

            // An accounting record proving the sale process
//   if($this->billService->bill->is_returned == 0){
//       $type=__('constants.journal_sales_bill_type');
//   }else{
//       $type=__('constants.journal_return_sales_bill_type');
//   }
            if ($this->billService->bill->is_returned == 0) {
                $type = __('constants.journal_sales_bill_type');
                $description = __('messages.sale_process');
            } else {
                $type = __('constants.journal_return_sales_bill_type');
                $description = __('messages.sale_process_return');
            }
            
            $proofSaleEntires = $this->salesSalesProofEntries();
            $journal = JournalService::createJournal(
                date: $this->billService->bill->release_date,
                type: $type,
                source: 'Sales bill',
                // description: __('messages.sale_process'),
                 description: $description,
                file: null,
                employee: null,
                status: 'accredited',
                debit: $proofSaleEntires['debit'],
                credit: $proofSaleEntires['credit'],
                journalable: $this->billService->bill,
                branch: $this->billService->branch,
                warehouse: $this->billService->warehouse,
            );
            // An accounting record proving the payment process
            $proofPaymentEntries = $this->salesProofPayment();
            JournalService::createJournal(
               date: $this->billService->bill->release_date ?? now(),
                type: $type,
                source: 'Sales bill',
                description: __('messages.payment_process'),
                file: null,
                employee: null,
                status: 'accredited',
                debit: $proofPaymentEntries['debit'],
                credit: $proofPaymentEntries['credit'],
                journalable: $this->billService->bill,
                branch: $this->billService->branch,
                warehouse: $this->billService->warehouse,
            );

            // An accounting entry proving the cost of the products
            $costEntries = $this->salesCostEntries();

            JournalService::createJournal(
             date: $this->billService->bill->release_date ?? now(),
                type:  $type,
                source: 'Sales bill',
                description: __('messages.cost_of_products'),
                file: null,
                employee: null,
                status: 'accredited',
                debit: $costEntries['debit'],
                credit: $costEntries['credit'],
                journalable: $this->billService->bill,
                branch: $this->billService->branch,
                warehouse: $this->billService->warehouse,
            );

            if ($this->billService->billWithProducts) {
                $processedItems = collect($this->billService->billProductService->billProcessedItemsData);

                // Filter items with 'is_stock' = 1
                $filteredProducts = $processedItems->filter(function ($product) {
                    return isset($product['item']) && $product['item']->is_stock == 1; // Ensure 'item' exists
                });

                // Convert to array before passing to the function
                $filteredProductsArray = $filteredProducts->toArray();

                if (!empty($filteredProductsArray)) {

                   if($this->billService->bill->is_returned == 0){
    $this->trackProductQuantity(
        products: $filteredProductsArray,
        journal: $journal,
        sign: '-',
    );

}else{
    $this->trackProductQuantity(
        products: $filteredProductsArray,
        journal: $journal,
        sign: '+',
    );
}

                }

            }
        });
    }

    private function createPurchaseJournalEntries(): void
    {
        DB::transaction(function () {
//             if($this->billService->bill->is_returned == 0){
//       $type= __('constants.journal_sales_purchase_type');
//   }else{
//       $type= __('constants.journal_return_sales_purchase_type');
//   }
            if ($this->billService->bill->is_returned == 0) {
                $type = __('constants.journal_sales_purchase_type');
                $description = __('messages.purchase_process');
            } else {
                $type = __('constants.journal_return_sales_purchase_type');
                $description = __('messages.purchase_process_return');
                
            }
            // An accounting record proving the purchase process
            $purchasesProofEntries = $this->purchaseSalesProofEntries();
            $journal = JournalService::createJournal(
               date: $this->billService->bill->release_date ?? now(),
                type:$type,
                source: 'Purchase bill',
                // description: __('messages.purchase_process'),
                description: $description,
                file: null,
                employee: null,
                status: 'accredited',
                debit: $purchasesProofEntries['debit'],
                credit: $purchasesProofEntries['credit'],
                journalable: $this->billService->bill,
                branch: $this->billService->branch,
                warehouse: $this->billService->warehouse,
            );
            // An accounting record proving the payment process
            $purchaseProofPayment = $this->purchaseProofPayment();
            JournalService::createJournal(
                  date: $this->billService->bill->release_date ?? now(),
                type: $type,
                source: 'Purchase bill',
                description: __('messages.payment_process'),
                file: null,
                employee: null,
                status: 'accredited',
                debit: $purchaseProofPayment['debit'],
                credit: $purchaseProofPayment['credit'],
                journalable: $this->billService->bill,
                branch: $this->billService->branch,
                warehouse: $this->billService->warehouse,
            );
            // An accounting record proving the payment of the expenses
            $otherExpensesEntries = $this->purchaseOtherExpensesEntries();
            JournalService::createJournal(
                 date: $this->billService->bill->release_date ?? now(),
                type: $type,
                source: 'Sales bill',
                description: __('messages.payment_for_expenses'),
                file: null,
                employee: null,
                status: 'accredited',
                debit: $otherExpensesEntries['debit'],
                credit: $otherExpensesEntries['credit'],
                journalable: $this->billService->bill,
                branch: $this->billService->branch,
                warehouse: $this->billService->warehouse,
            );
            if ($this->billService->billWithProducts) {
                $processedItems = collect($this->billService->billProductService->billProcessedItemsData);

                // Filter items with 'is_stock' = 1
                $filteredProducts = $processedItems->filter(function ($product) {
                    return isset($product['item']) && $product['item']->is_stock == 1; // Ensure 'item' exists
                });

                // Convert to array before passing to the function
                $filteredProductsArray = $filteredProducts->toArray();

                if (!empty($filteredProductsArray)) {
                if($this->billService->bill->is_returned == 0){
                        $this->trackProductQuantity(
                            products: $filteredProductsArray,
                            journal: $journal,
                            sign: '+',
                        );

                    }else{
                        $this->trackProductQuantity(
                            products: $filteredProductsArray,
                            journal: $journal,
                            sign: '-',
                        );
                    }
            }
            }
        });
    }

    private function salesCostEntries(): array
    {
        $entries = [
            'debit' => [],
            'credit' => [],
        ];
        $totalCost = 0;
        if($this->billService->bill->is_returned == 0){
      
        if ($this->billService->billWithProducts) {

            $entries['debit'][] =
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PRODUCTS_COSTS, 'sales'),
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $this->billService->billProductService->cost,
                    'entry_type' => "debit",
                ];
            $totalCost += $this->billService->billProductService->cost;

        }

        if ($this->billService->billWithServices) {

            $entries['debit'][] =
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_PRODUCTS_COSTS, 'sales'),
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $this->billService->billServiceService->cost,
                    'entry_type' => "debit",
                ];
            $totalCost += $this->billService->billServiceService->cost;

        }
        // dd($totalCost .','. $this->billService->billServiceService->cost . ',' . $this->billService->billProductService->cost- ($this->billService->bill->total_purchase));
        $entries['credit'][] =
            [
                'account' => $this->billService->warehouse->account,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $totalCost,
                'entry_type' => "credit",
            ];

}else{
    
   if ($this->billService->billWithProducts) {

            $entries['credit'][] =
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PRODUCTS_COSTS, 'sales'),
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $this->billService->billProductService->cost,
                    'entry_type' => "credit",
                ];
            $totalCost += $this->billService->billProductService->cost;

        }

        if ($this->billService->billWithServices) {

            $entries['credit'][] =
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_PRODUCTS_COSTS, 'sales'),
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $this->billService->billServiceService->cost,
                    'entry_type' => "credit",
                ];
            $totalCost += $this->billService->billServiceService->cost;

        }
        // dd($totalCost .','. $this->billService->billServiceService->cost . ',' . $this->billService->billProductService->cost- ($this->billService->bill->total_purchase));
        $entries['debit'][] =
            [
                'account' => $this->billService->warehouse->account,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $totalCost,
                'entry_type' => "debit",
            ]; 
}
        return $entries;
    }
    // private function salesCostEntries(): array
    // {
    //     $entries = [
    //         'debit' => [],
    //         'credit' => [],
    //     ];
    //     $totalCost = 0;

    //     // Handle products
    //     if ($this->billService->billWithProducts) {
    //         // Filter products where is_stock == 1
    //         $stockProducts = array_filter(
    //             $this->billService->billProductService->billProcessedItemsData,
    //             function ($product) {
    //                 return $product['item']->is_stock == 1;
    //             }
    //         );

    //         // Calculate the cost of stock products and add debit entries
    //         foreach ($stockProducts as $product) {
    //             $productCost = $product['item']->price * $product['quantity'];
    //            // Adjust cost calculation if necessary
    //             $entries['debit'][] = [
    //                 'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PRODUCTS_COSTS, 'sales'),
    //                 'type' => [
    //                     'type' => null,
    //                     'id' => null,
    //                 ],
    //                 'amount' => $productCost,
    //                 'entry_type' => "debit",
    //             ];
    //             $totalCost += $productCost;
    //         }
    //     }

    //     // Handle services
    //     if ($this->billService->billWithServices) {
    //         $serviceCost = $this->billService->billServiceService->cost;

    //         $entries['debit'][] = [
    //             'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_PRODUCTS_COSTS, 'sales'),
    //             'type' => [
    //                 'type' => null,
    //                 'id' => null,
    //             ],
    //             'amount' => $serviceCost,
    //             'entry_type' => "debit",
    //         ];
    //         $totalCost += $serviceCost;
    //     }
    // // dd($totalCost);
    //     // Add a credit entry for the total cost
    //     dd($totalCost);
    //     $entries['credit'][] = [
    //         'account' => $this->billService->warehouse->account,
    //         'type' => [
    //             'type' => null,
    //             'id' => null,
    //         ],
    //         'amount' => $totalCost,
    //         'entry_type' => "credit",
    //     ];

    //     return $entries;
    // }
//     private function salesSalesProofEntries(): array
//     {
//         $entries = [
//             'debit' => [],
//             'credit' => [],
//         ];
// // dd(($this->getProductsTotal(). ',' . $this->getProductsTax()). ','  .$this->getProductsDiscount(). ','  . ($this->getServicesTotal(). ','  . $this->getServicesTax()). ','  .  $this->getServicesDiscount());
// // dd( ($this->getProductsTax()) - $this->getProductsDiscount());
// $entries['debit'][] =
//             [
//                 'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_CLIENTS, 'sales'),
//                 'type' => [
//                     'type' => $this->billService->bill->billable_type,
//                     'id' => $this->billService->bill->billable_id,
//                 ],
//                 'amount' => ($this->getProductsTotal() + $this->getProductsTax()) - $this->getProductsDiscount() + ($this->getServicesTotal() + $this->getServicesTax()) -  $this->getServicesDiscount(),
//                 'entry_type' => "debit",
//             ];
//         $entries['credit'][] =
//             [
//                 'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SALES_VALUE_TAX, 'sales'),
//                 'type' => [
//                     'type' => null,
//                     'id' => null,
//                 ],
//                 'amount' => $this->getProductsTax() + $this->getServicesTax(),
//                 'entry_type' => "credit",
//             ];
//         $entries['debit'][] =
//             [
//                 'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_ALLOWED_DISCOUNT, 'sales'),
//                 'type' => [
//                     'type' => null,
//                     'id' => null,
//                 ],
//                 'amount' => $this->getProductsDiscount() + $this->getServicesDiscount(),
//                 'entry_type' => "debit",
//             ];
//         if ($this->billService->billWithProducts) {

//             $entries['credit'][] =
//                 [
//                     'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SALES, 'sales'),
//                     'type' => [
//                         'type' => null,
//                         'id' => null,
//                     ],
//                     'amount' => $this->getProductsTotal(),
//                     'entry_type' => "credit",
//                 ];
//         }

//         if ($this->billService->billWithServices) {
//             $entries['credit'][] =
//                 [
//                     'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_SALES, 'sales'),
//                     'type' => [
//                         'type' => null,
//                         'id' => null,
//                     ],

//                     'amount' => $this->getServicesTotal(),
//                     'entry_type' => "credit",
//                 ];
//         }
//         return $entries;
//     }

 private function salesSalesProofEntries(): array
    {
        $entries = [
            'debit' => [],
            'credit' => [],
        ];
// dd(($this->getProductsTotal(). ',' . $this->getProductsTax()). ','  .$this->getProductsDiscount(). ','  . ($this->getServicesTotal(). ','  . $this->getServicesTax()). ','  .  $this->getServicesDiscount());
// dd( ($this->getProductsTax()) - $this->getProductsDiscount());

if($this->billService->bill->is_returned == 0){


        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_CLIENTS, 'sales'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                'amount' => ($this->getProductsTotal() + $this->getProductsTax()) - $this->getProductsDiscount() + ($this->getServicesTotal() + $this->getServicesTax()) -  $this->getServicesDiscount(),
                'entry_type' => "debit",
            ];
        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SALES_VALUE_TAX, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $this->getProductsTax() + $this->getServicesTax(),
                'entry_type' => "credit",
            ];
        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_ALLOWED_DISCOUNT, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $this->getProductsDiscount() + $this->getServicesDiscount(),
                'entry_type' => "debit",
            ];
        if ($this->billService->billWithProducts) {

            $entries['credit'][] =
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SALES, 'sales'),
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $this->getProductsTotal(),
                    'entry_type' => "credit",
                ];
        }

        if ($this->billService->billWithServices) {
            $entries['credit'][] =
                [
                    'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_SALES, 'sales'),
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],

                    'amount' => $this->getServicesTotal(),
                    'entry_type' => "credit",
                ];
        }


    }else{


        $entries['credit'][] =
        [
            'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_CLIENTS, 'sales'),
            'type' => [
                'type' => $this->billService->bill->billable_type,
                'id' => $this->billService->bill->billable_id,
            ],
            'amount' => ($this->getProductsTotal() + $this->getProductsTax()) - $this->getProductsDiscount() + ($this->getServicesTotal() + $this->getServicesTax()) -  $this->getServicesDiscount(),
            'entry_type' => "credit",
        ];
    $entries['debit'][] =
        [
            'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SALES_VALUE_TAX, 'sales'),
            'type' => [
                'type' => null,
                'id' => null,
            ],
            'amount' => $this->getProductsTax() + $this->getServicesTax(),
            'entry_type' => "debit",
        ];
    $entries['credit'][] =
        [
            'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_ALLOWED_DISCOUNT, 'sales'),
            'type' => [
                'type' => null,
                'id' => null,
            ],
            'amount' => $this->getProductsDiscount() + $this->getServicesDiscount(),
            'entry_type' => "credit",
        ];
    if ($this->billService->billWithProducts) {

        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SALES, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $this->getProductsTotal(),
                'entry_type' => "debit",
            ];
    }

    if ($this->billService->billWithServices) {
        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_SALES, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],

                'amount' => $this->getServicesTotal(),
                'entry_type' => "debit",
            ];
    }

    }
        return $entries;
    }
    private function salesProofPayment(): array
    {
        $entries = [
            'debit' => [],
            'credit' => [],
        ];

        if (!$this->billService->bill->billPaymentMethod->payment) { // due payment
            return $entries;
        }
        if($this->billService->bill->is_returned == 0){
            $entries['debit'][] =
            [
                'account' => $this->billService->bill->billPaymentMethod->payment->account,
                'type' => [
                    'type' => $this->billService->bill->billPaymentMethod->payment_type,
                    'id' => $this->billService->bill->billPaymentMethod->payment_id,
                ],
                'amount' => $this->billService->bill->amount_paid,
                'entry_type' => "debit",
            ];

        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_CLIENTS, 'sales'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                //total services
                'amount' => $this->billService->bill->amount_paid,
                'entry_type' => "credit",
            ];
            
        }else{
        $entries['credit'][] =
            [
                'account' => $this->billService->bill->billPaymentMethod->payment->account,
                'type' => [
                    'type' => $this->billService->bill->billPaymentMethod->payment_type,
                    'id' => $this->billService->bill->billPaymentMethod->payment_id,
                ],
                'amount' => $this->billService->bill->amount_paid,
                'entry_type' => "credit",
            ];

        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_CLIENTS, 'sales'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                //total services
                'amount' => $this->billService->bill->amount_paid,
                'entry_type' => "debit",
            ];

}

        return $entries;
    }
    private function purchaseSalesProofEntries(): array
    {


        $tax_total = $this->getTotalTax();
        $entries = [
            'debit' => [],
            'credit' => [],
        ];

if($this->billService->bill->is_returned == 0){
    $entries['debit'][] =
            [
                'account' => $this->billService->warehouse->account,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => ($this->getProductsTotal()-($this->billService->bill->total_purchase)),
                'entry_type' => "debit",
            ];

         $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PRODUCTS_COSTS, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => ($this->billService->bill->total_purchase),
                'entry_type' => "debit",
            ];
         $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_PRODUCTS_COSTS, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => ($this->getServicesTotal()),
                'entry_type' => "debit",
            ];
        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PURCHASE_VALUE_TAX, 'Purchases'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $tax_total,
                'entry_type' => "debit",
            ];

        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SUPPLIERS, 'Purchases'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                'amount' => ($this->getProductsTotal() + $tax_total +$this->getServicesTotal()),

                'entry_type' => "credit",
            ];
    
}else{
    


        $entries['credit'][] =
            [
                'account' => $this->billService->warehouse->account,
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => ($this->getProductsTotal()-($this->billService->bill->total_purchase)),
                'entry_type' => "credit",
            ];

         $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PRODUCTS_COSTS, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => ($this->billService->bill->total_purchase),
                'entry_type' => "credit",
            ];
         $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SERVICE_PRODUCTS_COSTS, 'sales'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => ($this->getServicesTotal()),
                'entry_type' => "credit",
            ];
        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_PURCHASE_VALUE_TAX, 'Purchases'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $tax_total,
                'entry_type' => "credit",
            ];

        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SUPPLIERS, 'Purchases'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                'amount' => ($this->getProductsTotal() + $tax_total +$this->getServicesTotal()),

                'entry_type' => "debit",
            ];
}
        return $entries;
    }
    private function purchaseProofPayment(): array
    {
        $entries = [
            'debit' => [],
            'credit' => [],
        ];

        if (!$this->billService->bill->billPaymentMethod->payment) {

            return $entries;
        }
        
        if($this->billService->bill->is_returned == 0){
            $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SUPPLIERS, 'Purchases'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                'amount' => $this->billService->bill->amount_paid,
                'entry_type' => "debit",
            ];

        $entries['credit'][] =
            [
                'account' => $this->billService->bill->billPaymentMethod->payment->account,
                'type' => [
                    'type' => $this->billService->bill->billPaymentMethod->payment_type,
                    'id' => $this->billService->bill->billPaymentMethod->payment_id,
                ],
                'amount' => $this->billService->bill->amount_paid - $this->getTotalDiscount(),
                'entry_type' => "credit",
            ];
        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_EARNED_DISCOUNT,  'Purchases'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $this->getTotalDiscount(),
                'entry_type' => "credit",
            ];
            
        }else{
            $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_SUPPLIERS, 'Purchases'),
                'type' => [
                    'type' => $this->billService->bill->billable_type,
                    'id' => $this->billService->bill->billable_id,
                ],
                'amount' => $this->billService->bill->amount_paid,
                'entry_type' => "credit",
            ];

        $entries['debit'][] =
            [
                'account' => $this->billService->bill->billPaymentMethod->payment->account,
                'type' => [
                    'type' => $this->billService->bill->billPaymentMethod->payment_type,
                    'id' => $this->billService->bill->billPaymentMethod->payment_id,
                ],
                'amount' => $this->billService->bill->amount_paid - $this->getTotalDiscount(),
                'entry_type' => "debit",
            ];
        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel(AccountHelper::ACCOUNT_EARNED_DISCOUNT,  'Purchases'),
                'type' => [
                    'type' => null,
                    'id' => null,
                ],
                'amount' => $this->getTotalDiscount(),
                'entry_type' => "debit",
            ];
            
        }

        

        return $entries;
    }
    private function purchaseOtherExpensesEntries(): array
    {
        $otherExpenses = $this->getOtherExpenses();
        $otherExpensesTotal = $this->getOtherExpensesTotal();

        $entries = [
            'debit' => [],
            'credit' => [],
        ];

        if (!$otherExpensesTotal) {
            return $entries;
        }
 if($this->billService->bill->is_returned == 0){
     foreach ($otherExpenses as $expense) {
            $entries['debit'][] =
                [
                    'account' => $expense->expense->account,
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $expense->amount,
                    'entry_type' => "debit",
                ];
        }

        $entries['credit'][] =
            [
                'account' => AccountService::getAccountForModel($this->billService->bill->expensePaymentMethod->paymentMethod->account_name),
                'type' => [
                    'type' => $this->billService->bill->expensePaymentMethod->payment_type,
                    'id' => $this->billService->bill->expensePaymentMethod->payment_id,
                ],
                'amount' => $otherExpensesTotal,
                'entry_type' => "credit",
            ];
     
 }else{
     foreach ($otherExpenses as $expense) {
            $entries['credit'][] =
                [
                    'account' => $expense->expense->account,
                    'type' => [
                        'type' => null,
                        'id' => null,
                    ],
                    'amount' => $expense->amount,
                    'entry_type' => "credit",
                ];
        }

        $entries['debit'][] =
            [
                'account' => AccountService::getAccountForModel($this->billService->bill->expensePaymentMethod->paymentMethod->account_name),
                'type' => [
                    'type' => $this->billService->bill->expensePaymentMethod->payment_type,
                    'id' => $this->billService->bill->expensePaymentMethod->payment_id,
                ],
                'amount' => $otherExpensesTotal,
                'entry_type' => "debit",
            ];
     
 }
        

        return $entries;
    }

    private function getTotalTax(): float
    {
        return $this->billService->tax;
    }



    private function getOtherExpensesTotal(): float
    {
        return $this->billService->otherExpensesTotal;
    }

    private function getOtherExpenses(): array
    {
        return $this->billService->otherExpenses;
    }

    private function getServicesTax(): float
    {
        $tax = 0;

        if ($this->billService->billWithServices) {
            $tax += $this->billService->billServiceService->tax;
        }

        return $tax;
    }

    private function getProductsTax(): float
    {
        $tax = 0;

        if ($this->billService->billWithProducts) {
            $tax += $this->billService->billProductService->tax;
        }

        return $tax;
    }

    private function getTotalDiscount(): float
    {
        $discount = 0;

        $discount += $this->getServicesDiscount();

        $discount += $this->getProductsDiscount();

        return $discount;
    }

    private function getServicesDiscount(): float
    {
        $discount = 0;

        if ($this->billService->billWithServices) {
            $discount += ($this->billService->billServiceService->discount + $this->billService->billServiceService->totalDiscountOnTheBill);
        }

        return $discount;
    }

    private function getProductsDiscount(): float
    {
        $discount = 0;

        if ($this->billService->billWithProducts) {
            $discount += ($this->billService->billProductService->discount + $this->billService->billProductService->totalDiscountOnTheBill);
        }

        return $discount;
    }

    private function getProductsServicesTotal(): float
    {
        $total = 0;

        $total += $this->getServicesTotal();

        $total += $this->getProductsTotal();

        return $total;
    }

    private function getServicesTotal(): float
    {
        $total = 0;

        if ($this->billService->billWithServices) {
            $total += $this->billService->billServiceService->total;
        }

        return $total;
    }

    private function getProductsTotal(): float
    {
        $total = 0;

        if ($this->billService->billWithProducts) {
            $total += $this->billService->billProductService->total;
        }


        return $total;
    }

    private function trackProductQuantity(
        array $products,
        Journal $journal,
        string $sign = '+',
    ): void {

        foreach ($products as $product) {
            $quantity = $sign === '+' ? $product['quantity'] : -$product['quantity'];
            ProductTrackQuantity::dispatch(
                product: $product['item'],
                journal: $journal,
                productUnit: $product['item']->units->first(),
                quantity: $quantity,
                productWarehouse: $product['item']->warehouses->first(),
            );
        }
        return;
    }
}
