<?php

namespace Database\Factories;

use App\Models\Company;
use Illuminate\Database\Eloquent\Factories\Factory;

class AttributeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => [
                'ar' => $this->faker->name(),
                'en' => $this->faker->name(),
            ],
            'type' => $this->faker->randomElement([
                'group',
                'title',
            ]),
            'company_id' => function()
            {
                return Company::inRandomOrder()->first()->id;
            },
        ];
    }
}
