<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DropdownOption>
 */
class DropdownOptionFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $arr = ['employee_count', 'work_type'];

        return [
            'dropdown_name' => $arr[rand(0, count($arr) - 1)],
            'option_value' => rand(1, 5),
            'option_label' => fake()->word()
        ];
    }
}
