<?php

namespace Database\Factories;

use App\Models\Category;
use App\Models\DropdownOption;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $categoryIds = Category::where('type', 'products_category')->pluck('id')->toArray();
        $inventory_types = DropdownOption::where('dropdown_name', 'product_inventory_type')->pluck('id')->toArray();

        return [
            'code' =>  rand(200, 20000),
            'name' => fake()->name,
            'barcode' => fake()->paragraph(1),
            'description' => fake()->paragraph(),
            'category_id' => function () use ($categoryIds) {
                return $this->faker->randomElement($categoryIds);
            },
            'size' => rand(1, 20),
            'inventory_type_id' => function () use ($inventory_types) {
                return $this->faker->randomElement($inventory_types);
            },
            'has_expiry_date' => fake()->boolean,
        ];
    }
}
