<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('branche_employee', function (Blueprint $table) {
            $table->id();
             $table->foreignId("branche_id")->constrained("branches")->cascadeOnDelete();
            $table->foreignId("employee_id")->constrained("employees")->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branche_employee');
    }
};
