<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained();
            $table->string('code');
            $table->string('name');
            $table->text('description')->nullable();
            $table->foreignId('category_id')->constrained('categories');
            $table->boolean('fast_service');
            $table->foreignId('fast_service_id')->nullable()->constrained('categories');
            $table->boolean('second_employee');
            $table->decimal('second_employee_rate', 8, 2)->nullable();
            $table->foreignId('time_type_id')->nullable()->references('id')->on('dropdown_options');
            $table->integer('time_amount')->nullable();
            $table->boolean('calender_appearance')->nullable();
            $table->longText('internet_description')->nullable();
            $table->longText('details')->nullable();
            $table->boolean('status')->nullable();
            $table->boolean('processing')->nullable();
            $table->decimal('preparation_min', 8, 2)->nullable();
            $table->decimal('finishing_min', 8, 2)->nullable();
            $table->tinyInteger('pricing_type')->nullable();
            $table->decimal('price', 8, 2)->nullable();
            $table->decimal('home_price', 8, 2)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
