<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bound_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bound_id')->constrained();
            $table->string('entry_type');
            $table->unsignedBigInteger('entry_id');
            $table->decimal('value', 8, 2, true);
            $table->string('note');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bound_entries');
    }
};
