<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_information', function (Blueprint $table) {
            $table->foreignId('section_id')->constrained(table: 'careers_sections')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_information', function (Blueprint $table) {
            $table->dropForeign(['section_id']);
        });
    }
};
