<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('open_balance_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('open_balances_id')->constrained();
            $table->foreignId('journal_id')->constrained();
            $table->foreignId('product_id')->constrained();
            $table->foreignId('unit_id')->constrained('company_units');
            $table->decimal('quantity', 8, 2, true);
            $table->decimal('cost', 8, 2, true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('open_balance_products');
    }
};
