<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bounds', function (Blueprint $table) {
            $table->enum('voucher_type', ['supplier', 'client', 'employee', 'account'])->after('type');
            $table->foreignId('branch_id')->after('voucher_type')->constrained();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bounds', function (Blueprint $table) {});
    }
};
