<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_system_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained();
            $table->foreignId('system_settings_group_id')->constrained('system_settings_groups');
            $table->foreignId('system_setting_id')->constrained('system_settings');
            $table->string('sub_group');
            $table->boolean('value')->default(false);
            $table->timestamps();
            $table->unique(['company_id', 'system_settings_group_id', 'system_setting_id', 'sub_group'], 'unique_company_setting');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_system_settings');
    }
};
