<?php

namespace Database\Seeders;

use App\Models\DropdownOption;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DropdownOptionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // DropdownOption::factory(10)->create();

        $warehouse_dropdowns = [
            [
                'dropdown_name' => 'warehouse_type',
                'option_value' => '1',
                'option_label' => 'main'
            ],
            [
                'dropdown_name' => 'warehouse_type',
                'option_value' => '0',
                'option_label' => 'sub'
            ],
            [
                'dropdown_name' => 'warehouse_propose',
                'option_value' => '1',
                'option_label' => 'storage'
            ],
            [
                'dropdown_name' => 'warehouse_propose',
                'option_value' => '2',
                'option_label' => 'sales'
            ],
            [
                'dropdown_name' => 'warehouse_propose',
                'option_value' => '3',
                'option_label' => 'both'
            ]
        ];
        // foreach ($warehouse_dropdowns as $warehouse_drop) {
        //     DropdownOption::create($warehouse_drop);
        // }

        $product_inventory_types = [
            [
                'dropdown_name' => 'product_inventory_type',
                'option_value' => json_encode([
                    'ar' => 'يوميا',
                    'en' => 'daily',
                ]),
                'option_label' => 'daily'
            ],
            [
                'dropdown_name' => 'product_inventory_type',
                'option_value' => json_encode([
                    'ar' => 'أسبوعيا',
                    'en' => 'weekly',
                ]),
                'option_label' => 'weekly'
            ],
            [
                'dropdown_name' => 'product_inventory_type',
                'option_value' => json_encode([
                    'ar' => 'شهريا',
                    'en' => 'monthly',
                ]),
                'option_label' => 'monthly'
            ],
            [
                'dropdown_name' => 'product_inventory_type',
                'option_value' => json_encode([
                    'ar' => 'سنويا',
                    'en' => 'yearly',
                ]),
                'option_label' => 'yearly'
            ]

        ];

        foreach ($product_inventory_types as $type) {
            DropdownOption::create($type);
        }
    }
}
