<?php

namespace Database\Seeders;

use App\Models\Feature;
use Illuminate\Database\Seeder;
use App\Http\Enums\Package\FeatureTypeEnum;
use App\Http\Enums\Package\FeatureGroupEnum;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class FeatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $features = [
            [
                'type' => FeatureTypeEnum::bool,                'group' => FeatureGroupEnum::accounts,
                'key' => 'ACCOUNTS_TREE',
                'name' => [
                    'ar' => 'شجرة الحسابات',
                    'en' => 'accounts tree',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::accounts,
                'key' => 'ACCOUNTS_SETTINGS',
                'name' => [
                    'ar' => 'إعدادات الحسابات',
                    'en' => 'accounts settings',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::accounts,
                'key' => 'JOURNAL_ENTRIES',
                'name' => [
                    'ar' => 'قيود اليومية',
                    'en' => 'journal entries',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::accounts,
                'key' => 'PAYMENTS_AND_RECEIVABLES',
                'name' => [
                    'ar' => 'المقبوضات والمدفوعات',
                    'en' => 'receivables and payments',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::clients,
                'key' => 'CLIENTS',
                'name' => [
                    'ar' => 'العملاء',
                    'en' => 'clients',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::clients,
                'key' => 'CLIENTS_SETTINGS',
                'name' => [
                    'ar' => 'إعدادات العملاء',
                    'en' => 'clients settings',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::suppliers,
                'key' => 'SUPPLIERS',
                'name' => [
                    'ar' => 'الموردين',
                    'en' => 'suppliers',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::suppliers,
                'key' => 'SUPPLIERS_SETTINGS',
                'name' => [
                    'ar' => 'إعدادات الموردين',
                    'en' => 'suppliers settings',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::warehouses,
                'key' => 'PRODUCTS',
                'name' => [
                    'ar' => 'المنتجات',
                    'en' => 'products',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::warehouses,
                'key' => 'WAREHOUSES',
                'name' => [
                    'ar' => 'المستودعات',
                    'en' => 'warehouses',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::warehouses,
                'key' => 'SERVICES',
                'name' => [
                    'ar' => 'الخدمات',
                    'en' => 'services',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::warehouses,
                'key' => 'WAREHOUSES_SETTINGS',
                'name' => [
                    'ar' => 'إعدادات المستودعات',
                    'en' => 'warehouses settings',
                ]
            ],
            [
                'type' => FeatureTypeEnum::number,
                'group' => FeatureGroupEnum::branches,
                'key' => 'BRANCHES',
                'name' => [
                    'ar' => 'الفروع',
                    'en' => 'branches',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::purchases,
                'key' => 'PURCHASES',
                'name' => [
                    'ar' => 'فواتير الشراء',
                    'en' => 'purchases invoices',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::sales,
                'key' => 'SALES',
                'name' => [
                    'ar' => 'طلبات البيع',
                    'en' => 'sales orders',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::sales,
                'key' => 'FAST_SALES',
                'name' => [
                    'ar' => 'مبيعات سريعة',
                    'en' => 'fast sales',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::sales,
                'key' => 'ONLINE_SALES',
                'name' => [
                    'ar' => 'مبيعات عبر الإنترنت',
                    'en' => 'online sales',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::reports,
                'key' => 'TEACHER_REPORT',
                'name' => [
                    'ar' => 'تقرير المعلم',
                    'en' => 'teacher report',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::reports,
                'key' => 'JOURNAL_REPORT',
                'name' => [
                    'ar' => 'تقرير اليومية',
                    'en' => 'journal report',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::reports,
                'key' => 'TRIAL_BALANCE',
                'name' => [
                    'ar' => 'التوازن التجريبي',
                    'en' => 'trial balance',
                ]
            ],
            [
                'type' => FeatureTypeEnum::number,
                'group' => FeatureGroupEnum::workers,
                'key' => 'WORKERS',
                'name' => [
                    'ar' => 'العمال',
                    'en' => 'workers',
                ]
            ],
            [
                'type' => FeatureTypeEnum::number,
                'group' => FeatureGroupEnum::employees,
                'key' => 'EMPLOYEES',
                'name' => [
                    'ar' => 'الموظفين',
                    'en' => 'employees',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::revenues,
                'key' => 'COMPANY_REVENUES',
                'name' => [
                    'ar' => 'ايرادات الشركة',
                    'en' => 'Company Revenues',
                ]
            ],
            [
                'type' => FeatureTypeEnum::bool,
                'group' => FeatureGroupEnum::revenues,
                'key' => 'MERCHANT_REVENUES',
                'name' => [
                    'ar' => 'ايرادات التجار',
                    'en' => 'Merchants Revenues',
                ]
            ],
        ];


        foreach ($features as $feature) {
            Feature::create($feature);
        }
    }
}
