<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class GivePermission extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $role = Role::where('name', 'super admin')->first();

        $role->givePermissionTo([
            'create company',
            'view company',
            'edit company',
            'delete company',
        ]);

        $user = User::first();
        $user->assignRole('super admin');

        $role = Role::where('name', 'company')->first();
        $role->givePermissionTo([
            'view company',
            'edit company',
        ]);

    }
}
