<?php

namespace Database\Seeders;

use App\Models\MainModel;
use App\Models\ModelGroup;
use Illuminate\Database\Seeder;
use App\Http\Helper\AccountHelper;

class MainModelModelGroupSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $main_groups_with_accounts = [
            [
                'model_group_name' => 'Sales',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS_COSTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SALES,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_TREASURIES,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_BANKS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_CLIENTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SALES_VALUE_TAX,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_ALLOWED_DISCOUNT,
                        'type' => 'debit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Services',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_SERVICE_SALES,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SUPPLIES_WAREHOUSE,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SERVICE_PRODUCTS_COSTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SERVICE_EXPENSES,
                        'type' => 'debit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Purchases',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SUPPLIERS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_TREASURIES,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_BANKS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_EARNED_DISCOUNT,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_PURCHASE_VALUE_TAX,
                        'type' => 'debit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Sales Returns',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS_COSTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_CLIENTS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SALES,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_TREASURIES,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_BANKS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SALES_VALUE_TAX,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_ALLOWED_DISCOUNT,
                        'type' => 'credit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Purchases Returns',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_SUPPLIERS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_TREASURIES,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_BANKS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_EARNED_DISCOUNT,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_PURCHASE_VALUE_TAX,
                        'type' => 'credit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Inventory Adjustment',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'debit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_OPEN_BALANCE,
                        'type' => 'debit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Transfer',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'credit'
                    ],
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'debit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Damage',
                'main_accounts' => [
                    [
                        'account' => AccountHelper::ACCOUNT_PRODUCTS,
                        'type' => 'debit'
                    ],
                ],
            ],
            [
                'model_group_name' => 'Transfer Balance to Safe',
                'main_accounts' => [],
            ],
        ];

        foreach ($main_groups_with_accounts as $group) {
            $model_group = ModelGroup::whereJsonContains('name->en', $group['model_group_name'])->first();
            foreach ($group['main_accounts'] as $account) {
                $mainModel = MainModel::where('name', $account['account'])->first();
                $model_group->mainModels()->attach($mainModel, ['type' => $account['type']]);
            }
        }
    }
}
