<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class MerchantRevenuesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $faker = Faker::create();

        for ($i = 0; $i < 50; $i++) {
            $paymentMethods = [
                'tawseel' => 0,
                'shabka' => 0,
                'cash' => 0,
                'tahweel' => 0,
                'electronic' => 0,
                'wallet' => 0,
                'tap' => 0,
                'stc' => 0,
                'mada' => 0,
                'delivery' => 0,
            ];

            // Randomly select one payment method to have a non-zero value
            $selectedPaymentMethod = array_rand($paymentMethods);
            $paymentMethods[$selectedPaymentMethod] = $faker->randomFloat(2, 1, 1000);

            // Calculate totals and profits
            $totalWithoutTaxes = $faker->randomFloat(2, 100, 10000);
            $tax = $faker->randomFloat(2, 1, 1000);
            $total = $totalWithoutTaxes + $tax;
            $totalMerchantReceivables = $faker->randomFloat(2, 50, 5000);
            $totalCompanyProfits = $faker->randomFloat(2, 50, 5000);
            $totalForCompany = $faker->randomFloat(2, 50, 5000);

            DB::table('merchant_revenues')->insert([
                'company_id' => 262, // Assuming you have company ids from 1 to 10
                'code' => $faker->unique()->numberBetween(1000, 9999),
                'type' => $faker->randomElement(['sales', 'rent']),
                'date' => $faker->date(),
                'client_name' => $faker->name(),
                'phone' => $faker->phoneNumber(),
                'city' => $faker->city(),
                'tawseel' => $paymentMethods['tawseel'],
                'shabka' => $paymentMethods['shabka'],
                'cash' => $paymentMethods['cash'],
                'tahweel' => $paymentMethods['tahweel'],
                'electronic' => $paymentMethods['electronic'],
                'wallet' => $paymentMethods['wallet'],
                'tap' => $paymentMethods['tap'],
                'stc' => $paymentMethods['stc'],
                'mada' => $paymentMethods['mada'],
                'delivery' => $paymentMethods['delivery'],
                'total_without_taxes' => $totalWithoutTaxes,
                'tax' => $tax,
                'total' => $total,
                'total_merchant_receivables' => $totalMerchantReceivables,
                'total_company_profits' => $totalCompanyProfits,
                'total_for_company' => $totalForCompany,
            ]);
        }
    }
}
