<?php

namespace Database\Seeders;

use App\Models\PaymentMethod;
use App\Models\TreasuryBankNetwork;
use Illuminate\Database\Seeder;

class PaymentMethodSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $payment_methods = [
            [
                'name' => [
                    'ar' => 'cash ar',
                    'en' => 'cash en',
                ],
                'rule' => [
                    'bill_payment_method.id' => 'required|exists:treasuries,id,deleted_at,NULL',
                    'bill_payment_method.reference_number' => 'nullable|string',
                ],
                'model' => 'App\\Models\\Treasury',
                'account_name' => 'treasuries',
                'resource' => 'App\\Http\\Resources\\TreasuryResource',
            ],
            [
                'name' => [
                    'ar' => 'back ar',
                    'en' => 'back en',
                ],
                'rule' => [
                    'bill_payment_method.id' => 'required|exists:banks,id,deleted_at,NULL',
                    'bill_payment_method.sender_name' => 'nullable|string',
                ],
                'model' => 'App\\Models\\Bank',
                'account_name' => 'banks',
                'resource' => 'App\\Http\\Resources\\BankResource',
            ],
            [
                'name' => [
                    'ar' => 'network ar',
                    'en' => 'network en',
                ],
                'rule' => [
                    'bill_payment_method.id' => 'required|exists:networks,id,deleted_at,NULL',
                    'bill_payment_method.card_number' => 'required|string',
                    'bill_payment_method.type' => 'required|string',
                ],
                'model' => 'App\\Models\\Network',
                'account_name' => 'networks',
                'resource' => 'App\\Http\\Resources\\NetworkResource',
            ],
            [
                'name' => [
                    'ar' => 'holder ar',
                    'en' => 'holder en',
                ],
                'rule' => [
                    'bill_payment_method.id' => 'nullable|exists:employees,id,deleted_at,NULL',
                    'bill_payment_method.holder_name' => 'nullable|string',
                ],
                'model' => 'App\\Models\\Employee',
                'account_name' => 'holders',
                'resource' => 'App\\Http\\Resources\\EmployeeResource',
            ],
        ];

        foreach($payment_methods as $payment_method)
        {
            PaymentMethod::create($payment_method);
        }
    }
}
