<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class SalesOrdersPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'view',
            'show',
            'create',
            'edit',
            'delete',
        ];

        $permissionTranslations = [
            'view' => 'عرض',
            'show' => 'إظهار',
            'create' => 'إنشاء',
            'edit' => 'تعديل',
            'delete' => 'حذف',
        ];
        $models = [
            'Sales Orders' => 'طلبات البيع',
        ];
        $guards = [
            'worker',
            'company',
        ];
        foreach ($models as $model => $model_ar) {
            foreach ($guards as $guard) {
                foreach ($permissions as $permission) {
                    $permission_ar = $permissionTranslations[$permission] ?? $permission;
                    Permission::firstOrCreate([
                        'guard_name' => $guard,
                        'name' => "$permission $model",
                        'name_ar' => "$permission_ar $model_ar",
                    ]);
                }
            }
        }
    }
}
