<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ShiftPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'view' => 'عرض',
            'show' => 'إظهار',
            'create' => 'إنشاء',
            'edit' => 'تعديل',
            'delete' => 'حذف',
        ];

        $models = [
            'shifts' => 'الوردية',
        ];

        $guards = [
            'worker',
            'company',
        ];

        foreach ($models as $model => $model_ar) {
            foreach ($guards as $guard) {
                foreach ($permissions as $permission => $permission_ar) {
                    Permission::create([
                        'guard_name' => $guard,
                        'name' => "$permission $model",
                        'name_ar' => "$permission_ar $model_ar",
                    ]);
                }
            }
        }
    }
}
