<?php

namespace Database\Seeders;

use App\Models\TimeType;
use Illuminate\Database\Seeder;

class TimeTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $types = [
            [
                // 'company_id' => 100,
                'dropdown_name' => [
                    'ar' => 'دقيقة',
                    'en' => 'min',
                ],
                'option_value' => [
                    'ar' => 'دقيقة',
                    'en' => 'min',
                ],
                'option_label' => TimeType::KEY,
            ], [
                // 'company_id' => 100,
                'dropdown_name' => [
                    'ar' => 'ساعه',
                    'en' => 'hour',
                ],
                'option_value' => [
                    'ar' => 'ساعه',
                    'en' => 'hour',
                ],
                'option_label' => TimeType::KEY,
            ]
        ];

        foreach ($types as $type) {
            TimeType::create($type);
        }
    }
}
