<?php

use App\Models\Feature;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\MainUnitController;
use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\Auth\ProfileController;
use App\Http\Controllers\Api\MainCurrencyController;
use App\Http\Controllers\Api\Auth\RegisterController;
use App\Http\Controllers\Api\Account\AccountController;
use App\Http\Controllers\Api\Admin\MetaController;
use App\Http\Controllers\Api\Package\PackageController;
use App\Http\Controllers\Api\Category\CategoryController;
use App\Http\Controllers\Api\Location\LocationController;
use App\Http\Controllers\Api\Supplier\SupplierController;
use App\Http\Controllers\Api\Auth\ForgetPasswordController;
use App\Http\Controllers\Api\Adminstration\TimeTypeController;
use App\Http\Controllers\Api\Auth\EmailVerificationController;
use App\Http\Controllers\Api\Feature\FeatureController;
use App\Http\Controllers\CatogryUnitController;

use App\Http\Controllers\CurrencyController;

Route::post('login', [LoginController::class, 'login']);
Route::post('/register', [RegisterController::class, 'register']);
Route::get('/locations', [LocationController::class, 'index']);
Route::get('/packages', [PackageController::class, 'index']);
Route::get('/metas', [MetaController::class, 'index']);
Route::get('/advantages', [FeatureController::class, 'index']);
Route::get('/about-us', [FeatureController::class, 'aboutUs']);
Route::get('/convert', [CurrencyController::class, 'get']);

 Route::get('/unit-category', [CatogryUnitController::class, 'index']);
Route::group([
    'prefix' => 'forget-password',
    'controller' => ForgetPasswordController::class,
], function () {
    Route::post('/send-code', 'sendOtp');
    Route::post('/check-code', 'checkOtpCode');
    Route::patch('/reset-password', 'resetPassword');
});

// Route::post('test-login', [LoginController::class, 'testLogin']);

// Route::group([
//     'prefix' => 'locations',
//     'controller' => LocationController::class,
// ], function () {
//     Route::get('/', 'index');
//     // Route::get('/countries', 'countries');
//     // Route::get('/countries/{country}', 'cities');
//     // Route::get('/cities/{area}', 'areas');
// });

Route::middleware(['auth:sanctum'])->group(function () {

    Route::group([
        'prefix' => 'email-verification',
        'controller' => EmailVerificationController::class,
    ], function () {
        Route::post('/', 'verify');
        Route::post('/send-new-code', 'sendOtp');
    });

    Route::post('user/logout', [LoginController::class, 'logout']);
    Route::get('/user', [ProfileController::class, 'loggedInUser']);
    Route::put('/user', [ProfileController::class, 'updateProfile']);

    Route::group([
        'prefix' => 'suppliers',
        'controller' => SupplierController::class,
        'middleware' => [
            'check-company-supplier',
            'company-has-feature:' . Feature::FEATURE_SUPPLIERS,
        ],
    ], function () {
        Route::get('/',  'index')->withoutMiddleware('check-company-supplier');
        Route::post('/', 'store')->withoutMiddleware('check-company-supplier');
        Route::get('/{supplier}', 'show');
        Route::patch('/{supplier}', 'changeStatus');
        Route::put('/{supplier}',  'update');
        Route::delete('/{supplier}',  'destroy');
    });

    Route::group([
        'prefix' => '{type}/categories',
        'controller' => CategoryController::class,
        'middleware' => [
            'company-has-feature:' . Feature::FEATURE_WAREHOUSES_SETTINGS,
        ],
    ], function () {
        Route::get('/',  'index');
        Route::post('/', 'store');
        Route::put('/{category}',  'update');
        Route::delete('/{category}',  'destroy');
    });

    Route::group([
        'prefix' => 'accounts',
        'controller' => AccountController::class,
        'middleware' => [
            'account-company',
            'company-has-feature:' . Feature::FEATURE_ACCOUNTS_TREE,
        ],
    ], function () {
        Route::get('/search/',  'search');
        Route::get('/archive/',  'getArchivedAccounts');
        Route::patch('/archive/{id}',  'toggleArchiveAccount');
        Route::post('/create-pre-structured-accounts',  'createPreStructuredAccounts');
        Route::put('/transfer/{account}/{parent}',  'transferAccount');
        Route::get('/', 'index')->withoutMiddleware('account-company');
        Route::post('store/{account?}', 'store');
        Route::get('/expenses',  'getExpensesAccounts');
        Route::get('/{id}',  'show');
        Route::put('/{account}',  'update');
        Route::delete('/delete',  'destroy');
    });

    // Route::group([
    //     'prefix' => 'companies',
    //     'controller' => CompanyController::class
    // ], function () {
    //     Route::get('/',  'index');
    //     Route::get('/{company}', 'show');
    //     Route::post('/', 'store');
    //     Route::put('/{company}',  'update');
    //     Route::delete('/{company}',  'destroy');
    // });

    Route::get('time-types', [TimeTypeController::class, 'index']);
    Route::get('main-units', [MainUnitController::class, 'index']);
    Route::get('main-currencies', [MainCurrencyController::class, 'index']);
   
});
