<?php

use App\Http\Controllers\Api\Company\VacationRequest\VacationRequestController;
use App\Http\Controllers\Api\Employee\App\AttendanceController;
use App\Http\Controllers\Api\Employee\AppInformationController;
use App\Http\Controllers\Api\Employee\AppProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Employee\Auth\AuthController;
use App\Http\Controllers\Api\Employee\Auth\ChangePasswordController;
use App\Http\Controllers\Api\Employee\Auth\RegisterController;
use App\Http\Controllers\Api\Employee\Notification\EmployeeNotification;
use App\Http\Resources\AppProfileResource;
use Google\Client as GoogleClient;
use Illuminate\Support\Facades\Http;
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register-status', [RegisterController::class, 'registerStatus']);
Route::post('/register', [RegisterController::class, 'register']);


Route::group([
    'middleware' => ['auth:employee'],
    'prefix' => 'app'
], function () {

    Route::post('/logout', [AuthController::class, 'logout'])->withoutMiddleware('lang');
    Route::post('/delete-account', [AuthController::class, 'deleteAccount'])->withoutMiddleware('lang');

    Route::get('/home', [AttendanceController::class, 'getHome']);

    Route::get('/notifications', [EmployeeNotification::class, 'getNotifications'])->withoutMiddleware('lang');
    
     Route::get('/employee-branches', [AttendanceController::class, 'getEmployeeBranches']);

    Route::post('/attendance', [AttendanceController::class, 'attend'])->withoutMiddleware('lang');
    Route::get('/work-schedule', [AttendanceController::class, 'workSchedule']);
    Route::post('/departure', [AttendanceController::class, 'departure'])->withoutMiddleware('lang');

    Route::get('/vacations', [VacationRequestController::class, 'index']);
    Route::post('/vacations', [VacationRequestController::class, 'store']);
    Route::get('/app-information/{type}', [AppInformationController::class, 'index'])->where('type', 'video|audio');
    Route::post('/app-information', [AppInformationController::class, 'store']);
    Route::get('/app-information/profile', [AppProfileController::class, 'index']);

});
Route::group([
    'middleware' => [
        'auth:worker'
    ],
], function () {
    Route::patch('/change-password', [ChangePasswordController::class, 'update']);
});

Route::get('/testnotification', function () {

    $fcm = "fs1op8eaTJaaKH13sb7fad:APA91bGwBmXf6rdG0MLd9A940YhW8tq5PhdOrJjqtk2GNhsqgdVCv3b-ZDZQN-ymG_u0JLp-mMiuVmRwKYJ3uqr3_EH70oitIo3VV08yiMLQkBAd4KXhjADyhUEU_-1kqe5zOd5AVa9W";

    $title = "اشعار جديد";
    $description = "تيست تيست تيست";

//    $credentialsFilePath = "json/file.json";  // local
    $credentialsFilePath = Http::get(asset('json/file.json')); // in server
    $client = new GoogleClient();
    $client->setAuthConfig($credentialsFilePath);
    $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
    $client->refreshTokenWithAssertion();
    $token = $client->getAccessToken();

    $access_token = $token['access_token'];

    $headers = [
        "Authorization: Bearer $access_token",
        'Content-Type: application/json'
    ];

    $data = [
        "message" => [
            "token" => $fcm,
            "notification" => [
                "title" => $title,
                "body" => $description,
            ],
        ]
    ];
    $payload = json_encode($data);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/v1/projects/hesabak-b484f/messages:send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_VERBOSE, true); // Enable verbose output for debugging
    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    
})->withoutMiddleware('lang')->name('testnotification');
