<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class CustomModelCommand extends Command
{
    /**
     * The name and signature of the console command.
     *   Option	Description
     *    name	The name of the model.
     *    --m	Create a migration file for the model.
     *    --c	Create a controller for the model and accept the pass.
     *    --r	Create a resource route for the model.
     *    --Rs	Create a store form request.
     *    --Ru	Create a update form request.
     *   --api	Generate the controller as api controller.
     * @var string
     */
    protected $signature = 'make:custom-model {name} {--m} {--c=} {--r} {--Rs=} {--Ru=} {--api}';

    /**
     * The console command description.
     * @var string
     */
    protected $description = 'Create a custom model with specific flags';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $model = $this->argument('name');
        $migration = $this->option('m');
        $controller = $this->option('c');
        $resource = $this->option('r');
        $store_request = $this->option('Rs');
        $update_request = $this->option('Ru');
        $api_controller = $this->option('api');

        $this->makeModel([
            "model" => $model, "migration" =>
            $migration
        ]);

        if ($controller) {
            $this->makeController([
                "controller" => $controller,
                "model" => $model,
                "api" => $api_controller
            ]);
        }

        if ($store_request) {
            $this->makeRequest([
                "request" => $store_request,
                "model" => $model,
                "type" => 'Store'
            ]);
        }

        if ($update_request) {
            $this->makeRequest([
                "request" => $update_request,
                "model" => $model,
                "type" => 'Update'
            ]);
        }

        if ($resource) {
            $this->makeResource(["model" => $model]);
        }

        $this->info('All success!');
    }

    protected function makeRequest($data)
    {
        $request_path = $data['request'] . '/' . $data['model'] . '/';
        $request_name = $data['type'] . $data['model'] . 'Request';
        $request = $request_path . $request_name;

        // Artisan::call('make:request', [
        //     'name' =>   $request,
        // ]);

        $this->info($data['type'] . ' request created successfully : ' . $request);
    }

    protected function makeModel($data)
    {
        // Artisan::call('make:model', [
        //     'name' => $data['model'],
        //     '-m' => $data['migration']
        // ]);

        $path = 'App/Models/' . $data['model'];
        $data['migration']
            ?  $this->info('Model and migration file created successfully : ' . $path)
            : $this->info('Model created : ' . $path);
    }

    protected function makeController($data)
    {
        // Artisan::call('make:controller', [
        //     'name' => $data['controller'] . '/' . $data['model'] . '/' . $data['model'] . 'Controller',
        //     '--api' => $data['api'],
        //     '--model' => $data['model']
        // ]);

        $path = 'App/Http/' . $data['controller'] . '/' . $data['model'] . '/' . $data['model'] . 'Controller';
        $data['api']
            ? $this->info('API controller created successfully : ' . $path)
            :  $this->info('Controller created successfully : ' . $path);
    }

    protected function makeResource($data)
    {
        // Artisan::call('make:resource', [
        //     'name' => $model . 'Resource'
        // ]);
        $path = 'App/Http/Resources/' .  $data['model'] . 'Resource';
        $this->info('Resource created successfully : ' . $path);
    }
}
