<?php

namespace App\Exceptions;

use Throwable;
use App\Trait\ApiTrait;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Validation\ValidationException;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;

class Handler extends ExceptionHandler
{
    use ApiTrait;
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }


    public function render($request, Throwable $exception)
    {
        if ($request->is('api/*')) {
            if ($exception instanceof ModelNotFoundException) {
                return $this->apiResponse(message: 'Model not fount.', code: false);
            } elseif ($exception instanceof MethodNotAllowedHttpException) {
                return $this->apiResponse(message: 'Method Not supported', code: false);
            } elseif ($exception instanceof NotFoundHttpException) {
                return $this->apiResponse(message: 'Page Not found', code: false);
            } elseif ($exception instanceof ValidationException) {
                return $this->apiResponse(code: false, message: $exception->getMessage(), errors: $exception->errors());
            } elseif ($exception instanceof AuthenticationException) {
                return $this->apiResponse(message: $exception->getMessage(), code: false);
            } elseif ($exception instanceof AuthorizationException) {
                return $this->apiResponse(message: $exception->getMessage(), code: false);
            } else {
                return $this->apiResponse(
                    message: $exception->getMessage(),
                    data: [
                        'file' => $exception->getFile(),
                        'line' => $exception->getLine()
                    ],
                    code: false
                );
            }
        }

        return parent::render($request, $exception);
    }
}
