<?php

namespace App\Http\Controllers\Api\Account;

use App\Models\Account;
use App\Trait\ApiTrait;
use App\Models\MainModel;
use App\Models\ModelGroup;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ModelGroupResource;
use App\Http\Resources\AccountModelResource;

class AccountModelController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: ModelGroupResource::collection(
                ModelGroup::with([
                    'mainModels:id,label',
                    'mainModels.accounts' => fn ($q) => $q->whereBelongsTo(CompanyHelper::getCompany(request()))
                ])->get(['id', 'name'])
            )
        );
    }

    public function store(Account $account, MainModel $model)
    {
        $account->model()->attach($model);
        return $this->apiResponse(message: "Account added to this model successfully.");
    }

    public function destroy(Account $account, MainModel $model)
    {
        $account->model()->detach($model);
        return $this->apiResponse(message: "Account removed to this model successfully.");
    }
}
