<?php

namespace App\Http\Controllers\Api\Admin\Auth;

use App\Models\Admin;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Http\Resources\AdminResource;
use App\Http\Requests\Api\Auth\LoginRequest;
use Illuminate\Validation\ValidationException;

class AdminAuthController extends Controller
{
    use ApiTrait;

    public function login(LoginRequest $request)
    {
        $admin = Admin::where('email', $request->email)->first();

        if (!$admin || !Hash::check($request->password, $admin->password)) {
            throw ValidationException::withMessages([
                'email' => ['Invalid email or password.']
            ]);
        }

        return $this->apiResponse(
            data: [
                'user' => AdminResource::make($admin),
                'token' => $admin->createToken('admin')->plainTextToken,
            ],
            message: "Login successfully.",
        );
    }

    public function logout()
    {
        request()->user('admin')->currentAccessToken()->delete();
        return $this->apiResponse(
            message: "Logged out successfully."
        );
    }
}
