<?php

namespace App\Http\Controllers\Api\Admin\Auth;

use App\Models\Admin;
use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Admin\Admin\Auth\ChangePasswordRequest;
use App\Http\Requests\Api\Admin\Admin\Auth\UpdateProfileRequest;
use App\Http\Resources\AdminResource;

class AdminProfileController extends Controller
{
    use ApiTrait;

    public function show()
    {
        return $this->apiResponse(
            data: AdminResource::make(self::getAuthAdmin())
        );
    }

    public function update(UpdateProfileRequest $request)
    {
        self::getAuthAdmin()->update($request->validated());
        return $this->apiResponse(
            data: AdminResource::make(self::getAuthAdmin()),
            message: "Profile updated successfully.",
        );
    }

    private static function getAuthAdmin()
    {
        return Admin::where('id', auth('admin')->id())->first();
    }
}
