<?php

namespace App\Http\Controllers\Api\Admin\Package;

use App\Models\Package;
use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Resources\PackageResource;
use App\Http\Requests\Api\Admin\Package\PackageRequest;

class PackageController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: PackageResource::collection(Package::get()),
        );
    }

    public function store(PackageRequest $request)
    {
        return $this->apiResponse(
            data: PackageResource::make(Package::create($request->validated())),
            message: "Package created successfully.",
        );
    }

    public function show(Package $package)
    {
        return $this->apiResponse(
            data: PackageResource::make($package),
        );
    }

    public function update(PackageRequest $request, Package $package)
    {
        $package->update($request->validated());
        return $this->apiResponse(
            data: PackageResource::make($package),
            message: "Package updated successfully.",
        );
    }

    public function changeStatus(Package $package)
    {
        $package->update([
            'status' => !$package->status,
        ]);
        return $this->apiResponse(
            data: PackageResource::make($package),
            message: "Status changed successfully.",
        );
    }

    public function destroy(Package $package)
    {
        $package->delete();
        return $this->apiResponse(
            message: "Package deleted successfully.",
        );
    }
}
