<?php

namespace App\Http\Controllers\Api\Bound;

use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Enums\Bound\BoundTypeEnum;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\BoundResource;
use App\Http\Services\Bound\BoundService;
use App\Http\Requests\Api\Bound\BoundRequest;
use App\Models\Bound;

class BoundController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: BoundResource::collection(
                CompanyHelper::getCompany()->bounds()
                    ->where('type', BoundTypeEnum::getValueFromString(request()->route()->type))
                    ->with(['entry:id,name', 'payment:id,name'])
                    ->get()
            ),
        );
    }

    public function show(string $type, Bound $bound)
    {
        $bound->load(['entry:id,name', 'payment:id,name']);

        return $this->apiResponse(
            data: BoundResource::make($bound),
        );
    }

    public function store(BoundRequest $request)
    {
        (new BoundService)->create($request);

        return $this->apiResponse(
            message: "Bound created successfully.",
        );
    }

    public function destroy(string $type, Bound $bound)
    {
        $bound->delete();

        return $this->apiResponse(
            message: "Bound deleted successfully.",
        );
    }
}
