<?php

namespace App\Http\Controllers\Api\Branch;

use App\Models\Branch;
use App\Models\Address;
use App\Models\Company;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Enums\Branch\BranchTypeEnum;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\BranchResource;
use App\Http\Resources\BranchEmployeeResource;
use App\Http\Requests\Api\Branch\StoreBranchRequest;
use App\Http\Requests\Api\Branch\UpdateBranchRequest;

class BranchController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $branches = auth('worker')->check() ?  auth('worker')->user()->employee->branch :  Branch::whereBelongsTo(CompanyHelper::getCompany(request()))
            ->with('warehouses')
            ->get();
        return $this->apiResponse(data: BranchResource::collection($branches));
    }

    public function show(Branch $branch)
    {
        $branch->load(['warehouses', 'deliveries', 'company.sellNatures']);
        return $this->apiResponse(data: BranchResource::make($branch));
    }

    public function branchEmployee(Branch $branch)
    {
        $branch->load('employees');
        return $this->apiResponse(data: BranchResource::make($branch));
    }

    public function store(StoreBranchRequest $request)
    {
        $address = Address::create($request->only([
            'address_line',
            'post_code',
            'area_id',
        ]));

        $branch = CompanyHelper::getCompany(request())
            ->branches()
            ->create([
                'address_id' => $address->id,
                'type' => BranchTypeEnum::getValueFromString($request->type),
            ]  + $request->validated());
        // $branch->jobTypes()->sync($request->job_types);

        return $this->apiResponse(
            data: BranchResource::make($branch),
            message: 'Branches created successfully.'
        );
    }

    public function update(UpdateBranchRequest $request, Branch $branch)
    {
        $branch->update([
            'type' => BranchTypeEnum::getValueFromString($request->type),

        ] + $request->validated());
        $branch->address()->update($request->only([
            'address_line',
            'post_code',
            'area_id',
        ]));
        // $branch->jobTypes()->sync($request->job_types);

        return $this->apiResponse(data: new BranchResource($branch), message: 'Branches updated successfully.');
    }

    public function destroy(Branch $branch)
    {
        $branch->delete();
        return $this->apiResponse(message: 'Branches deleted successfully.');
    }
}
