<?php

namespace App\Http\Controllers\Api\Branch\Warehouse;

use App\Models\Bill;
use App\Models\Journal;
use App\Models\Product;
use App\Trait\ApiTrait;
use App\Models\Warehouse;
use App\Http\Helper\AccountHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\BillResource;
use App\Http\Resources\JournalResource;
use App\Http\Resources\ProductResource;
use App\Http\Resources\WarehouseResource;
use Illuminate\Validation\ValidationException;

class ProductWarehouseController extends Controller
{
    use ApiTrait;

    public function show(Warehouse $warehouse, Product $product)
    {
        $warehouse->load(['branch']);

        $product->load([
            'warehouses' => function ($query) use ($warehouse) {
                return $query->where('warehouse_id', $warehouse->id);
            },
            'units' => function ($query) {
                return $query->orderBy('conversion_factor');
            },
        ]);

        $open_balance =   $product->openBalanceJournal(
            $product
                ->warehouses
                ->first()
        )
            ->with(['entries.account' => function ($query) {
                return $query->whereHas('model', function ($query) {
                    return $query->where('name', AccountHelper::ACCOUNT_PRODUCTS);
                });
            }])
            ->first();

        return $this->apiResponse(
            data: [
                'warehouse' => WarehouseResource::make($warehouse),
                'product' => ProductResource::make($product),
                'bills_journals' => JournalResource::collection(
                    Journal::billOfProduct($product)->with([
                        'journalable', 'entries.account' => function ($query) {
                            return $query->whereHas('model', function ($query) {
                                return $query->where('name', AccountHelper::ACCOUNT_PRODUCTS);
                            });
                        }
                    ])->get()
                ),
                'open_balance_journal' => $open_balance ? JournalResource::make($open_balance) : null
            ]
        );
    }
}
