<?php

namespace App\Http\Controllers\Api\Branch\Warehouse;

use App\Trait\ApiTrait;
use App\Models\Warehouse;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Resources\WarehouseResource;
use App\Http\Requests\Api\Warehouse\StoreWarehouseRequest;
use App\Http\Requests\Api\Warehouse\UpdateWarehouseRequest;

class WarehouseController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(data: WarehouseResource::collection(
            CompanyHelper::getCompany()
                ->warehouses()
                ->with(['branches',])
                ->withSum('products', 'value')
                ->get()
        ));
    }

    public function show(Warehouse $warehouse)
    {
        $warehouse->load([
            'products.product.units',
            'products.product.tax',
            'branches',
        ]);

        $warehouse->loadSum('products', 'value');

        return $this->apiResponse(data: new WarehouseResource($warehouse));
    }

    public function store(StoreWarehouseRequest $request)
    {
        $warehouse = CompanyHelper::getCompany(request())->warehouses()->create($request->validated());
        $warehouse->branches()->sync($request->branch_ids);
        return $this->apiResponse(data: new WarehouseResource($warehouse), message: 'Warehouse created successfully.');
    }

    public function update(UpdateWarehouseRequest $request, Warehouse $warehouse)
    {
        $warehouse->update($request->validated());
        $warehouse->branches()->sync($request->branch_ids);
        return $this->apiResponse(data: new WarehouseResource($warehouse), message: 'Warehouse updated successfully.');
    }

    public function destroy(Warehouse $warehouse)
    {
        $warehouse->delete();
        return $this->apiResponse(message: 'Warehouse deleted successfully.');
    }
}
