<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ChangeLangRequest;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class ChangeLangController extends Controller
{
    use ApiTrait;

    public function __invoke(ChangeLangRequest $request)
    {
        $user = $request->user();
        $user->update([
            'lang' => $request->lang
        ]);

        return $this->apiResponse(message: "Lang Changed successfully.");
    }
}
