<?php

namespace App\Http\Controllers\Api\Company\Absence;

use App\Models\Absence;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\AbsenceResource;
use App\Http\Requests\Api\Company\Absence\StoreAbsenceRequest;
use App\Http\Requests\Api\Company\Absence\UpdateAbsenceRequest;

class AbsenceController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $absences = AbsenceResource::collection($request->user()->absences()->with('employee')->get());
        return $this->apiResponse(data: $absences);
    }

    public function store(StoreAbsenceRequest $request)
    {
        $absence = new AbsenceResource($request->user()->absences()->create($request->validated()));
        return $this->apiResponse(data: $absence, message: "Absence created successfully.");
    }

    public function update(UpdateAbsenceRequest $request, Absence $absence)
    {
        $absence->update($request->validated());
        $absence = new AbsenceResource($absence);
        return $this->apiResponse(data: $absence, message: "Absence updated successfully.");
    }

    public function destroy(Absence $absence)
    {
        $absence->delete();
        return $this->apiResponse(message: "Absence deleted successfully.");
    }
}
