<?php

namespace App\Http\Controllers\Api\Company\Currency;

use App\Models\Company;
use App\Trait\ApiTrait;
use App\Models\MainCurrency;
use App\Models\CompanyCurrency;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\Currency\StoreCompanyCurrencyRequest;
use App\Http\Requests\Api\Company\Currency\UpdateCompanyCurrencyRequest;
use App\Http\Resources\CurrencyResource;

class CompanyCurrencyController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $currencies = Company::find(auth()->id())->currencies;
        $currencies = CurrencyResource::collection($currencies);
        return $this->apiResponse(data: $currencies);
    }

    public function store(StoreCompanyCurrencyRequest $request)
    {
        $currency = Company::find(auth()->id())->currencies()->create($request->validated());
        $currency = new CurrencyResource($currency);
        return $this->apiResponse(data:$currency, message:'Currency created successfully.');
    }

    public function update(UpdateCompanyCurrencyRequest $request, CompanyCurrency $companyCurrency)
    {
        $companyCurrency->update($request->validated());
        $companyCurrency = new CurrencyResource($companyCurrency);
        return $this->apiResponse(data:$companyCurrency, message:'Currency updated successfully.');
    }

    public function destroy(CompanyCurrency $companyCurrency)
    {
        $companyCurrency->delete();
        return $this->apiResponse(message: "Currency deleted successfully.");
    }
}
