<?php

namespace App\Http\Controllers\Api\Company\TreasuryBankNetwork;

use App\Trait\ApiTrait;
use App\Models\Network;
use App\Http\Controllers\Controller;
use App\Http\Resources\NetworkResource;
use App\Http\Requests\Api\Company\Network\StoreNetworkRequest;
use App\Http\Requests\Api\Company\Network\UpdateNetworkRequest;

class NetworkController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: NetworkResource::collection(
                Network::where('company_id', auth('company')->id())->get()
            )
        );
    }

    public function store(StoreNetworkRequest $request)
    {
        return $this->apiResponse(data: new NetworkResource(Network::create(['company_id' => auth('company')->id()] + $request->validated())), message: "network created successfully.");
    }

    public function show(Network $network)
    {
        return $this->apiResponse(data: new NetworkResource($network));
    }

    public function update(UpdateNetworkRequest $request, Network $network)
    {
        $network->update($request->validated());
        return $this->apiResponse(data: new NetworkResource($network), message: "network updated successfully.");
    }

    public function destroy(Network $network)
    {
        $network->delete();
        return $this->apiResponse(message: "network deleted successfully.");
    }
}
