<?php

namespace App\Http\Controllers\Api\Company\Vacation;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Company\Vacation\StoreVacationRequest;
use App\Http\Requests\Api\Company\Vacation\UpdateVacationRequest;
use App\Http\Resources\VacationResource;
use App\Models\Vacation;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;

class VacationController extends Controller
{
    use ApiTrait; // authorization

    public function index(Request $request)
    {
        $vacations = VacationResource::collection($request->user()->vacations);
        return $this->apiResponse(data: $vacations);
    }

    public function show(Vacation $vacation)
    {
        $vacation = new VacationResource($vacation);
        return $this->apiResponse(data: $vacation);
    }

    public function store(StoreVacationRequest $request)
    {
        $vacation = new VacationResource($request->user()->vacations()->create($request->validated()));
        return $this->apiResponse(data: $vacation, message: "Vacation created successfully.");
    }

    public function update(UpdateVacationRequest $request, Vacation $vacation)
    {
        $vacation->update($request->validated());
        $vacation = new VacationResource($vacation);
        return $this->apiResponse(data: $vacation, message: "Vacation updated successfully.");
    }

    public function destroy(Vacation $vacation)
    {
        $vacation->delete();
        return $this->apiResponse(message: "Vacation deleted successfully.");
    }
}
