<?php

namespace App\Http\Controllers\Api\Employee\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Employee\Auth\ChangeEmployeePasswordRequest;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ChangePasswordController extends Controller
{
    use ApiTrait;

    public function update(ChangeEmployeePasswordRequest $request)
    {
        $user = $request->user('employee');
        $user->update([
            'password' => Hash::make($request->password),
        ]);
        $user->tokens()->delete();
        $token = $user->createToken('employee')->plainTextToken;
        return $this->apiResponse(message: "Password updated successfully.", data: ['token' => $token]);
    }
}
