<?php

namespace App\Http\Controllers\Api\Employee\Career;

use App\Models\Career;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Employee\Career\StoreCareerRequest;
use App\Http\Requests\Api\Employee\Career\UpdateCareerRequest;
use App\Http\Resources\CareerSectionResource;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class CareerController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $company = $request->user();
        $careers = $company->careers()->where('type', Career::CAREER_TYPE)->get();
        $careers = CareerSectionResource::collection($careers);
        return $this->apiResponse(data: $careers);
    }

    public function show(Career $career)
    {
        if ($career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }
        $career = new CareerSectionResource($career);
        return $this->apiResponse(data: $career);
    }

    public function store(StoreCareerRequest $request)
    {
        $company = $request->user();
        $career = $company->careers()->create($request->validated());
        $career = new CareerSectionResource($career);
        return $this->apiResponse(message: 'Career created successfully.', data: $career);
    }
    public function update(UpdateCareerRequest $request, Career $career)
    {
        if ($career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }
        $career->update($request->all());
        $career = new CareerSectionResource($career);
        return $this->apiResponse(message: 'Career updated successfully.', data: $career);;
    }
    public function destroy(Career $career)
    {
        if ($career->type !== Career::CAREER_TYPE) {
            throw new NotFoundHttpException();
        }
        $career->delete();
        return $this->apiResponse(message: 'Career deleted successfully.');;
    }
}
