<?php

namespace App\Http\Controllers\Api\Employee\Section;

use App\Models\Section;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Employee\Section\StoreSectionRequest;
use App\Http\Requests\Api\Employee\Section\UpdateSectionRequest;
use App\Http\Resources\CareerSectionResource;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class SectionController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $company = $request->user();
        $sections = $company->sections()->where('type', Section::SECTION_TYPE)->get();
        $sections = CareerSectionResource::collection($sections);
        return $this->apiResponse(data: $sections);
    }

    public function show(Section $section)
    {
        if ($section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }
        $section = new CareerSectionResource($section);
        return $this->apiResponse(data: $section);
    }

    public function store(StoreSectionRequest $request)
    {
        $company = $request->user();
        $section = $company->sections()->create($request->validated());
        $section = new CareerSectionResource($section);
        return $this->apiResponse(message: 'Section created successfully.', data: $section);
    }
    public function update(UpdateSectionRequest $request, Section $section)
    {
        if ($section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }
        $section->update($request->all());
        $section = new CareerSectionResource($section);
        return $this->apiResponse(message: 'Section updated successfully.', data: $section);;
    }
    public function destroy(Section $section)
    {
        if ($section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }
        $section->delete();
        return $this->apiResponse(message: 'Section deleted successfully.');;
    }
}
