<?php

namespace App\Http\Controllers\Api\Service;

use App\Models\Service;
use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Services\ServiceService;
use App\Http\Requests\Api\Service\StoreServiceRequest;
use App\Http\Requests\Api\Service\UpdateServiceRequest;
use App\Http\Resources\ServiceResource;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    use ApiTrait;

    public function __construct(
        public ServiceService $serviceService
    ) {
    }

    public function index()
    {
        return $this->apiResponse(
            data: ServiceResource::collection(CompanyHelper::getCompany(request())->services)
        );
    }

    public function show(Service $service)
    {
        $service->load([
            'productServiceUnits',
            'branches',
        ]);
        return $this->apiResponse(data: ServiceResource::make($service));
    }

    public function store(StoreServiceRequest $request)
    {
        return $this->apiResponse(
            data: ServiceResource::make($this->serviceService->create($request->validated())),
            message: 'Service created successfully.',
        );
    }

    public function update(UpdateServiceRequest $request, Service $service)
    {
        $this->serviceService->update($service, $request->validated());
        return $this->apiResponse(
            data: ServiceResource::make($service),
            message: 'Service updated successfully.',
        );
    }

    public function destroy(Service $service)
    {
        $service->delete();
        return $this->apiResponse(message: 'Service deleted successfully.');
    }
}
