<?php

namespace App\Http\Controllers\Api\Supplier;

use App\Models\Address;
use App\Trait\ApiTrait;
use App\Models\Supplier;
use App\Http\Helper\CompanyHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\SupplierResource;
use App\Http\Requests\Api\Supplier\StoreSupplierRequest;
use App\Http\Requests\Api\Supplier\UpdateSupplierRequest;
use App\Http\Requests\Api\Supplier\ChangeSupplierStatusRequest;

class SupplierController extends Controller
{
    use ApiTrait;

    public function index()
    {
        return $this->apiResponse(
            data: SupplierResource::collection(
                Supplier::whereBelongsTo(CompanyHelper::getCompany(request()))
                    ->whereDoesntHave('blocked')
                    ->with(
                        [
                            'address.area.city.country',
                            'entries'
                        ]
                    )->get()
            )
        );
    }

    public function store(StoreSupplierRequest $request)
    {
        $address = Address::create($request->only(['post_code', 'address_line', 'area_id']));
        return $this->apiResponse(
            message: 'Supplier Created successfully.',
            data: SupplierResource::make(
                Supplier::create(
                    ['address_id' => $address->id] + $request->validated()
                )
            )
        );
    }

    public function show(Supplier $supplier)
    {
        $supplier->load([
            'address',
            'entries.journal',
        ]);

        return $this->apiResponse(data: SupplierResource::make($supplier));
    }

    public function update(UpdateSupplierRequest $request, Supplier $supplier)
    {
        $supplier->update($request->validated());
        $supplier->address->update($request->only(['post_code', 'address_line', 'area_id']));

        return $this->apiResponse(message: 'Supplier Updated successfully.', data: SupplierResource::make($supplier));
    }

    public function destroy(Supplier $supplier)
    {
        $supplier->delete();
        return $this->apiResponse(message: 'Supplier Deleted successfully.');
    }

    public function changeStatus(ChangeSupplierStatusRequest $request, Supplier $supplier)
    {
        $supplier->update([
            'status' => $request->status,
        ]);

        return $this->apiResponse(message: 'Supplier Updated successfully.', data: SupplierResource::make($supplier));
    }
}
